"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _lodash = require("lodash");
/**
 *    Copyright 2017 floragunn GmbH

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

// TODO what is this used for?
function _default(pluginRoot, server, APP_ROOT, API_ROOT) {
  const config = server.config();
  const basePath = config.get('server.basePath');
  const backend = server.plugins.searchguard.getSearchGuardBackend();
  const urlparamname = server.config().get('searchguard.auth.jwt.url_param');
  const headername = "Authorization";
  server.ext('onPostAuth', async function (request, next) {
    var jwtBearer = request.state.searchguard_jwt;
    var jwtAuthParam = request.query[urlparamname];
    if (jwtAuthParam != null) {
      jwtBearer = jwtAuthParam;
      next.state('searchguard_jwt', jwtBearer);
    }
    if (jwtBearer != null) {
      var headerValue = "Bearer " + jwtBearer;
      var headers = {};
      headers[headername] = headerValue;
      (0, _lodash.assign)(request.headers, headers);
    }
    return next.continue();
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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